/** @file   youkocontroller.cpp
 * @brief   Implementation of YoukoController - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "youkocontroller.h"
#include "warglobals.h"
#include "utils.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================

/** Constructor
 */
YoukoController::YoukoController( GameObject* pObject ) :
  NpcController( pObject ),
  
  m_centerPos( pObject->position() ),
  m_maxDistance1( 120 )
{
  this->youkoState( YOUKO_ARRESTED );
  this->m_pFollowObject = WarGlobals::pObjTable->pPlayer;
}



/** Destructor
 */
YoukoController::~YoukoController()
{
}




///
/// Public methods
/// ==============

/** Updates this controller
 */
void YoukoController::updateNpc()
{
  /*
  switch ( m_youkoState ) {
    case ( YOUKO_ARRESTED ): {
      break;
    }
    case ( YOUKO_FOLLOW_PLAYER ): {
      this->followObject();
      break;
    }
  }
  */
}



/** Changes the state the Youko operates
 */
void YoukoController::youkoState( int nstate )
{
  m_youkoState = nstate;
  if ( m_youkoState == YOUKO_ARRESTED ) {
    this->state( NpcController::NPC_FREEZE );
    
  } else if ( m_youkoState == YOUKO_FOLLOW_PLAYER ) {
    this->state( NpcController::NPC_FOLLOW_OBJECT );
    
  } else if ( m_youkoState == YOUKO_FIGHT ) {
    this->state( NpcController::NPC_FIGHT );
    
  }
}



/** Sets the centerposition
 */
void YoukoController::centerPosition( const Vec2D& cpos )
{
  m_centerPos = cpos;
}





///
/// Getter methods
/// ==============

/** Returns the current state
 */
int YoukoController::youkoState() const
{
  return m_youkoState;
}




///
/// Private or Protected methods
/// ============================

} // end of namespace

/**
 * Version history
 * ===============
 * $Log: youkocontroller.cpp,v $
 * Revision 1.1.1.1  2006/01/21 23:02:44  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:15:39+02  lamminsa
 * Initial revision
 *
 */
